import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(8, 6))

# Define colors for statuses
status_colors = {
    'clear': 'green',
    'occupied': 'red',
    'hand_empty': 'blue'
}

# Draw the table
table = patches.Rectangle((0, 0), 12, 1, linewidth=1, edgecolor='black', facecolor='lightgrey')
ax.add_patch(table)
ax.text(6, 0.5, 'Table', ha='center', va='center', fontsize=10, color='black')

# Draw blocks with positions and statuses
blocks = {
    'a': {'position': (1, 1), 'status': 'occupied', 'support': 'd'},
    'b': {'position': (5, 1), 'status': 'occupied', 'support': 'c'},
    'c': {'position': (5, 2), 'status': 'clear'},
    'd': {'position': (1, 2), 'status': 'clear'},
    'e': {'position': (9, 1), 'status': 'clear'},
}

for block, info in blocks.items():
    color = status_colors[info['status']]
    rect = patches.Rectangle(info['position'], 2, 1, linewidth=1, edgecolor='black', facecolor=color)
    ax.add_patch(rect)
    ax.text(info['position'][0] + 1, info['position'][1] + 0.5, f'Block {block.upper()}\n{info["status"].capitalize()}',
            ha='center', va='center', fontsize=8, color='white')

# Draw the hand
hand = patches.Ellipse((6, 4), 1, 0.5, linewidth=1, edgecolor='black', facecolor=status_colors['hand_empty'])
ax.add_patch(hand)
ax.text(6, 4, 'Hand\nEmpty', ha='center', va='center', fontsize=8, color='white')

# Add a legend
legend_patches = [
    patches.Patch(color=status_colors['clear'], label='Clear'),
    patches.Patch(color=status_colors['occupied'], label='Occupied'),
    patches.Patch(color=status_colors['hand_empty'], label='Hand Empty')
]
ax.legend(handles=legend_patches, loc='upper left', fontsize=8)

# Set limits and hide axes
ax.set_xlim(0, 12)
ax.set_ylim(0, 5)
ax.axis('off')

# Save the figure
plt.savefig('blocksworld/one_shot/ini_diagram_code/attempts/attempt_25.png', bbox_inches='tight')
plt.show()